/**
*
* MD Gallery v1 [build1.0]
* Copyright (c) 2007 D. Molanphy, Molanphy Design
* 
* This software may be used in personal and commercial projects provided the 
* source code retains the above copyright notice.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 
* NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
*
*/


//==============================================================================================
//---- FUNCTION TO PLACE MAIN NAVIGATION
//==============================================================================================
var oldNav:MovieClip;

function buildMainNav():Void {
	if (!mainTL.gallery_mc.mainNav_mc) {
		var mainNav:MovieClip = mainTL.gallery_mc.createEmptyMovieClip("mainNav_mc", mainTL.gallery_mc.getNextHighestDepth());

		for (var i:Number = 0; i < gallery_obj.numNodes; i++) {
			mainNav.attachMovie("button.nav", "mainNav_" + i, i, {_x:0, _y:-30});
			
			if (i < gallery_obj.numNodes - 1) {
				mainNav["mainNav_" + i].name_txt.autoSize = true;
				mainNav["mainNav_" + i].name_txt.text = gallery_obj.gallery[i].buttonName.toString() + "    |    ";
			} else {
				mainNav["mainNav_" + i].name_txt.autoSize = true;
				mainNav["mainNav_" + i].name_txt.text = gallery_obj.gallery[i].buttonName.toString();
			}

			// build it
			var tWidth:Number = mainNav["mainNav_" + i].name_txt.textWidth;
			mainNav["mainNav_" + i].button._width = tWidth;
			mainNav["mainNav_" + i]._x = mainNav["mainNav_" + (i-1)].button._width + mainNav["mainNav_" + (i-1)]._x;

			// add functions
			mainNav["mainNav_" + i].onRollOver = function() {
				this.colorTo(mainTL.linkColor, 0);
			}

			mainNav["mainNav_" + i].onRollOut = function() {
				this.colorTo(null, 1, 'easeOutExpo');
			}

			mainNav["mainNav_" + i].onRelease = function() {
				var quickNum:Number = this._name.substr(8);
				galleryDisplayed = quickNum;
				
				// load new one
				thumbnailCount = 0;
				thumbs_arr = null;
				gallery_mc.thumbs_mc.removeMovieClip();
				gallery_mc.mask_mc.removeMovieClip();
				gallery_mc.buttons_mc.removeMovieClip();
				library_xml.load(dirPath + "xml/" + gallery_obj.gallery[galleryDisplayed].xmlPath);
				
				// manage buttons
				oldNav.enabled = true;
				oldNav.colorTo(null, 0);
				this.colorTo(mainTL.linkColor, 0);
				this.enabled = false;
				oldNav = this;
			}
		}

		// deactivate first nav
		mainNav.mainNav_0.colorTo(mainTL.linkColor, 0);
		mainNav.mainNav_0.enabled = false;
		oldNav = mainNav.mainNav_0;

		// fade in
		mainNav._alpha = 0;
		mainNav._x = gallery_mc.mask_mc._width - mainNav._width;
		mainNav.alphaTo(100, 1, 'easeOutSine');

	}
};